﻿window.dsbscrolling = new function () {
    // Konfiguration
    var timer = null;
    var stop = 0;
    var iPosition = 0;
    var iSekPause = 5000;
    var iGeschwidigkeit = 5;
    var iVerzoegerungPixel = 0;
    var iMaxPosition = 0;
    var nurunten = false;
    var touchtimer;
    var scrolldown = false;
    var tpause = 5000;


    this.Start = function (speed, onlydown, containerpause, endpause, touchpause) {
        console.log('dsbscrolling.Start(speed: ' + speed + ', onlydown: ' + onlydown + ', containerpause: ' + containerpause + ', endpause: ' + endpause + ', touchpause: ' + touchpause + ')');
        iGeschwidigkeit = speed;
        nurunten = onlydown;
        iSekPause = containerpause;
        iSekLetztePause = endpause;
        tpause = touchpause;
        initme();
        if (iMaxPosition < 1) return;
        NachUnten();
    }

    initme = function () {
        window.scrollTo(0, 0);
        iVerzoegerungPixel = getPageVisibleArea();
        iDocumentHeight = getDocumentHeight();
        iMaxPosition = iDocumentHeight - iVerzoegerungPixel;
    }

    NachUnten = function () {
        scrolldown = true;
        if (stop != 0) return;
        iPosition++;
        if (iPosition <= iMaxPosition) {
            window.scrollBy(0, 1);
            var t = 1000;
            if ((iPosition % iVerzoegerungPixel == 0) || iPosition == 1) //page scrolled -> pause
            {
                t = (iSekPause);
            } else if (iPosition == (iMaxPosition - 1)) //document scrolled -> pause
            {
                t = (iSekLetztePause);
            } else //normalscroll
            {
                t = iGeschwidigkeit;
            }
            window.clearTimeout(timer);
            var that = NachUnten;
            timer = window.setTimeout(function () {
                that();
            }, t);
        } else {
            if (nurunten) {
                iPosition = 0;
                window.scrollTo(0, 0);
                window.clearTimeout(timer);
                var that = NachUnten;
                timer = window.setTimeout(function () {
                    that();
                }, t);
            } else {
                NachOben();
            }
        }
    }


    NachOben = function () {
        scrolldown = false;
        if (stop != 0) return;
        iPosition--;
        if (iPosition > 0) {
            window.scrollBy(0, -1);
            if (iPosition % iVerzoegerungPixel == 0) {
                window.clearTimeout(timer);
                var that = NachOben;
                timer = window.setTimeout(function () {
                    that();
                }, iSekPause);
            } else if (iPosition == (1)) {
                window.clearTimeout(timer);
                var that = NachOben;
                timer = window.setTimeout(function () {
                    that();
                }, iSekPause);
            } else {
                window.clearTimeout(timer);
                var that = NachOben;
                timer = window.setTimeout(function () {
                    that();
                }, iGeschwidigkeit);
            }
        } else {
            NachUnten();
        }
    }

    getDocumentHeight = function () {
        var b = window.document.body;
        var d = window.document.documentElement;
        if (b === null || d === null) return;
        return Math.max(b.scrollHeight, b.offsetHeight, d.clientHeight, d.scrollHeight, d.offsetHeight, window.outerHeight);
    }

    getPageVisibleArea = function () {
        if (window.innerHeight) {
            return (window.innerHeight);
        } else {
            return (window.document.body.offsetHeight);
        }
    }

    this.touch = function () {
        stop = 1;
        clearTimeout(touchtimer);
        touchtimer = setTimeout(function () {
            stop = 0;
            console.log('touchtimer');
            if (scrolldown) {
                NachUnten();
            } else {
                NachOben();
            }

        }, tpause);
    }
    document.addEventListener('touchstart', this.touch, true);
    document.addEventListener('click', this.touch, true);
}