﻿window.dsbscaling = new function () {
    var visibleWidth, actualWidth;
    var visibleHeight, actualHeight;
    var widthRatio, heightRatio;

    scaleBody = function (wRatio, hRatio) {
        document.documentElement.style.transform = "scale(" + wRatio + ", " + hRatio + ")";
        document.documentElement.style.transformOrigin = "0px 0px";
    }

    refreshSize = function() {
        visibleHeight = window.innerHeight;
        actualHeight = document.documentElement.scrollHeight;
        heightRatio = visibleHeight / actualHeight;

        visibleWidth = window.innerWidth;
        actualWidth = document.body.scrollWidth;
        widthRatio = visibleWidth / actualWidth;
    }
    
    this.None = function() {
        scaleBody(1, 1);
    }

    this.SectorWidth = function () {
        refreshSize();
        scaleBody(widthRatio, widthRatio);
    }

    this.SectorHeight = function () {
        refreshSize();
        scaleBody(heightRatio, heightRatio);
    }

    this.Sector = function () {
        refreshSize();
        scaleBody(widthRatio, heightRatio);
    }

    this.SectorProportions = function () {
        refreshSize();
        if (visibleHeight <= visibleWidth)
            scaleBody(heightRatio, heightRatio);
        else
            scaleBody(widthRatio, widthRatio);
    }

    this.UniformToFill = function() {
        refreshSize();
        if (actualHeight < actualWidth) {
            scaleBody(widthRatio + (heightRatio - 1), heightRatio);
        } else
            scaleBody(widthRatio, heightRatio + widthRatio - 1);
    }
}